﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Text.RegularExpressions;
using System.Threading.Tasks;

namespace VeteransAffairs.Registries.BusinessAHOBPR
{
    public class MilitaryOccupationInfo
    {
        private string occupationType = string.Empty;
        public MilitaryOccupationInfo(STD_SERVICE_OCCUPATION occupation, DateTime startDate, string occupationType)
        {
            OccupationType = occupationType;
            Occupation = occupation;
            StartDate = startDate;
        }
        public STD_SERVICE_OCCUPATION Occupation { get; set; }
        public DateRange DateRange { get; set; }
        public DateTime StartDate { get; set; }
        public string OccupationType {
            get { return occupationType; }
            set {
                if(Regex.IsMatch(value, "^[DdPpSs]{1}"))
                {
                    occupationType = value;
                }else
                {
                    throw new ArgumentOutOfRangeException(nameof(value), $"Invalid OccupationType: {value}. Valid Occupation types are D, P, or S.");
                }
            }
        }
    }
}
